{26. Sukurti dvipusi sarasa. Nukopijuoti i pradzia didziausia saraso elementa.}

program kopijuotiDidziausia;
type
	elementoRodykle = ^elementas;
	elementas  = record
		duomenys : integer;
		kitas : elementoRodykle;
		ankstesnis : elementoRodykle;
	end;

//------------------------------------------

//Procedura sukuria sarasa.
procedure Itraukti(var paskutinis : elementoRodykle; var pirmas : elementoRodykle; duomenys : integer);
var
	naujoRodykle : elementoRodykle;
begin
	if pirmas = nil then
	begin
		new(naujoRodykle);
		naujoRodykle^.duomenys := duomenys;
		naujoRodykle^.kitas := nil;
		naujoRodykle^.ankstesnis := nil;

		pirmas := naujoRodykle;
		paskutinis := naujoRodykle;
	end
	else begin
		new(naujoRodykle);
		naujoRodykle^.duomenys := duomenys;
		naujoRodykle^.kitas := nil;
		naujoRodykle^.ankstesnis := paskutinis;

		paskutinis^.kitas := naujoRodykle;
		paskutinis := naujoRodykle;
	end;
end;
//------------------------------------------

//Procedura atspausdina sarasa.
procedure Isvedimas(pirmas : elementoRodykle);
var
    dabartinis : elementoRodykle;
    i : integer;
begin
    i := 1;
    dabartinis := pirmas;
    while dabartinis <> nil do
            begin
                writeln('[', i, '] => ', dabartinis^.duomenys);
                dabartinis := dabartinis^.kitas;
                inc(i);
            end;
end;
//------------------------------------------

//Funkcija randa didziausia saraso elementa (jei yra du tokio pat dydzio
//elementai, tai didziausias bus pirmasis elementas.
function rastiDidziausia(pirmas : elementoRodykle): elementoRodykle;
var
    max : integer;
    einamasis, maxRodykle : elementoRodykle;
begin
    max := pirmas^.duomenys;       //buvo klaida itoj funkcijoj
	maxRodykle := pirmas;          //ios eiluts trko
    einamasis := pirmas;
    while einamasis <> nil do
        begin
            if einamasis^.duomenys > max then
                begin
                    max := einamasis^.duomenys;
                    maxRodykle := einamasis;
                end;
            einamasis := einamasis^.kitas;
        end;
    rastiDidziausia := maxRodykle;
end;
//------------------------------------------

procedure kopijuoti(kopijuojamas : elementoRodykle; var pirmas : elementoRodykle);
var
    naujas : elementoRodykle;
begin
    new(naujas);
    naujas^.duomenys := kopijuojamas^.duomenys;
    pirmas^.ankstesnis := naujas;
    naujas^.kitas := pirmas;
    naujas^.ankstesnis := nil;
    pirmas := naujas;
end;


//------------------------------------------

procedure naikintiSarasa(pirmas : elementoRodykle);
var dabartinis : elementoRodykle;
begin
    while pirmas <> nil do
        begin
            dabartinis:=pirmas^.kitas;
            dispose(pirmas);
            pirmas:=dabartinis;
        end;
    pirmas := nil;
    writeln('Sarasas panaikintas');
end;
//------------------------------------------

var
    pirmas, paskutinis, didziausias : elementoRodykle;
    a, i : integer;
begin
    pirmas := nil;      //is pradziu sarasas tuscias
    paskutinis := nil;

    writeln('Uzduotis: sukurti dvipusi sarasa. Nukopijuoti i pradzia didziausia jo elementa.');
    writeln('Iveskite saraso elementus, jo pabaiga pazymekite skaiciumi 0.');
    readln(a);
    while a = 0 do
        begin
            writeln('Saraso nera. Prasome ivesti bent viena saraso elementa,');
            writeln('o saraso pabaiga pazymeti skaiciumi 0:');
            readln(a);
        end;
    while a <> 0 do    //ciklu kuriam sarasa
        begin
            itraukti(paskutinis, pirmas, a);
            inc(i);
			readln(a);
        end;

    writeln;
    writeln('Sarasas:');   //atspausdinam sarasa
    isvedimas(pirmas);
    writeln;

    didziausias := rastiDidziausia(pirmas);        //randam didziausia elementa
    writeln('didziausias = ', didziausias^.duomenys);
    writeln;
    
    kopijuoti(didziausias, pirmas);
    isvedimas(pirmas);
    writeln;
    
    naikintiSarasa(pirmas);
    readln;
end.
